function ActivateTowerLimit(_limit)
	TowerLimit = _limit;
	TowerLimit_LastCreated = {};
	TowerLimit_InUpgradeProgress = 0;
	TowerLimitJob = 0;
	TowerLimit_BuildingsInUpgradeProgress = {}
	
	TowerTypes = 	{}
	TowerTypes[Entities.PB_Tower2] = true
	TowerTypes[Entities.PB_Tower3] = true
	TowerTypes[Entities.PB_DarkTower2] = true
	TowerTypes[Entities.PB_DarkTower3] = true
	
	TowerLimitCount = 0;
	
	for towers,_ in pairs(TowerTypes) do
		TowerLimitCount = TowerLimitCount + Logic.GetNumberOfEntitiesOfTypeOfPlayer(1, towers);
	end
	
	IsTower = function(_EntType)
		if TowerTypes[_EntType] then
			return true;
		end
		return false;
	end
	
	IsLvl1Tower = function(_Id)
		local type = Logic.GetEntityType(_Id)
		if type == Entities.PB_Tower1
		or type == Entities.PB_DarkTower1 then
			return true;
		end
		return false;
	end
	
	IsLvl2Tower = function(_Id)
		local type = Logic.GetEntityType(_Id)
		if type == Entities.PB_Tower2
		or type == Entities.PB_DarkTower2 then
			return true;
		end
		return false;
	end
	
	EMS_RF_TowerLimit_EntityCreated = function()
		local Id = Event.GetEntityID();
		local pId = Logic.EntityGetPlayer(Id);
		if pId ~= 1 then
			return
		else
			local EntitiesType = Logic.GetEntityType(Id)
			if not IsTower(EntitiesType) then
-----------------------------------------------------------------------------------		
				if gvTypesToTrack[EntitiesType] then
					Player1Units[Id] = true;
					return;
				end;
-----------------------------------------------------------------------------------	
				if gvTypesToTrackBuildings[EntitiesType] then
					Player1Buildings[Id] = true;
					return;
				end
-----------------------------------------------------------------------------------
				return;
			else
				if TowerLimitCount > TowerLimit then
					table.insert(TowerLimit_LastCreated,Id);
					if TowerLimitJob == 0 then
						TowerLimitJob = StartSimpleHiResJob("EMS_RF_TowerLimit_DestroyEntity");
					end
				else
					TowerLimitCount = TowerLimitCount + 1;
				end
				return;
			end
		end
	end
	
	EMS_RF_TowerLimit_EntityDestroyed = function()
		local Id = Event.GetEntityID();
		local pId = Logic.EntityGetPlayer(Id);
		if not IsTower(Logic.GetEntityType(Id)) or pId ~= 1 then
			return;
		end
		if TowerLimitCount > 0 then
			TowerLimitCount = TowerLimitCount - 1;
		end
	end
	
	EMS_RF_TowerLimit_DestroyEntity = function()
		for i = 1, table.getn(TowerLimit_LastCreated) do
			DestroyEntity(TowerLimit_LastCreated[i]);
		end
		TowerLimitJob = 0;
		return true;
	end
	
	--Trigger.RequestTrigger( Events.LOGIC_EVENT_ENTITY_CREATED, "", "EMS_RF_TowerLimit_EntityCreated", 1);
	Trigger.RequestTrigger( Events.LOGIC_EVENT_ENTITY_DESTROYED, "", "EMS_RF_TowerLimit_EntityDestroyed", 1);
	
	GameCallback_OnBuildingUpgradeComplete_TL = GameCallback_OnBuildingUpgradeComplete;
	GameCallback_OnBuildingUpgradeComplete = function(_oId, _nId)
		if IsLvl2Tower(_nId) then
			if TowerLimit_InUpgradeProgress > 0 then
				TowerLimit_InUpgradeProgress = TowerLimit_InUpgradeProgress - 1;
			else
				TowerLimit_InUpgradeProgress = 0;
			end
		end
		if TowerLimit_BuildingsInUpgradeProgress[_oId] then
			TowerLimit_BuildingsInUpgradeProgress[_oId] = nil;
		end
		GameCallback_OnBuildingUpgradeComplete_TL(_oId, _nId);
	end
	
	GUIAction_CancelUpgrade_TL = GUIAction_CancelUpgrade;
	GUIAction_CancelUpgrade = function()
		local sel = GUI.GetSelectedEntity();
		if IsLvl1Tower(sel) then
			if TowerLimit_InUpgradeProgress > 0 then
				TowerLimit_InUpgradeProgress = TowerLimit_InUpgradeProgress - 1;
			else
				TowerLimit_InUpgradeProgress = 0;
			end
		end
		if TowerLimit_BuildingsInUpgradeProgress[sel] then
			TowerLimit_BuildingsInUpgradeProgress[sel] = nil;
		end
		GUIAction_CancelUpgrade_TL();
	end
	
	GUIAction_UpgradeSelectedBuilding_TL = GUIAction_UpgradeSelectedBuilding;
	GUIAction_UpgradeSelectedBuilding = function()
		local sel = GUI.GetSelectedEntity();
		if not IsLvl1Tower(sel) then
			GUIAction_UpgradeSelectedBuilding_TL();
			return;
		end
		if (TowerLimitCount+TowerLimit_InUpgradeProgress) < TowerLimit then
			GUIAction_UpgradeSelectedBuilding_TL();
		end
	end
	
	UpgradeSingleBuilding_TL = GUI.UpgradeSingleBuilding;
	GUI.UpgradeSingleBuilding = function(_entity)
		local sel = _entity;
		if Logic.EntityGetPlayer(sel) ~= 1 then
			return UpgradeSingleBuilding_TL(sel);
		end
		if IsLvl1Tower(sel) then
			if not TowerLimit_BuildingsInUpgradeProgress[sel] then
				TowerLimit_BuildingsInUpgradeProgress[sel] = true;
			else
				return;
			end
			if (TowerLimitCount+TowerLimit_InUpgradeProgress) < TowerLimit then
				TowerLimit_InUpgradeProgress = TowerLimit_InUpgradeProgress + 1;
				UpgradeSingleBuilding_TL(sel);
			end
			return;
		end
		UpgradeSingleBuilding_TL(sel);
	end
	
	GUITooltip_UpgradeBuilding_TL = GUITooltip_UpgradeBuilding;
	GUITooltip_UpgradeBuilding = function(_BuildingType, _DisabledTooltip, _NormalTooltip, _TechnologyType)
		GUITooltip_UpgradeBuilding_TL(_BuildingType, _DisabledTooltip, _NormalTooltip, _TechnologyType);
		local towerLvl = 1;
		if _BuildingType == Entities.PB_Tower1 or _BuildingType == Entities.PB_DarkTower1 then
			if _TechnologyType ~= nil then
				local TechState = Logic.GetTechnologyState(GUI.GetPlayerID(), _TechnologyType)			
				if TechState == 0 then
					return;
				end
			end
			if Logic.GetTechnologyState(GUI.GetPlayerID(), Technologies.GT_GearWheel) ~= 4 then
				return;
			end
		elseif _BuildingType == Entities.PB_Tower2 or _BuildingType == Entities.PB_DarkTower2 then
			if _TechnologyType ~= nil then
				local TechState = Logic.GetTechnologyState(GUI.GetPlayerID(), _TechnologyType)			
				if TechState == 0 then
					return;
				end
			end
			if Logic.GetTechnologyState(GUI.GetPlayerID(), Technologies.GT_Metallurgy) ~= 4 then
				return;
			end
			towerLvl = 2;
		else
			return;
		end
		local currentBuildings = TowerLimitCount+ TowerLimit_InUpgradeProgress;
		local color;
		if currentBuildings < TowerLimit or towerLvl == 2 then
			color = " @color:0,255,0 ";
		else
			color = " @color:255,0,0 ";
		end
		local oldToolTip = XGUIEng.GetStringTableText("MenuTower/UpgradeTower"..towerLvl.."_normal");
		local start, ende = string.find(oldToolTip, "@cr");
		start = start or 0;
		ende = ende or 0;
		local newToolTip = string.sub(oldToolTip, 1, start-1) .. color .. "("..currentBuildings.."/"..TowerLimit..") @cr "
							.. string.sub(oldToolTip, ende+1);
		XGUIEng.SetText(gvGUI_WidgetID.TooltipBottomText, newToolTip);
	end
end